'use strict';

const axios = require("axios");
exports.main = async function (event, context) {
  let req = event.queryString
  console.log('queryString:', req);
  console.log('out_trade_no:', req.out_trade_no);

  const {UOS_APP_ID, UOS_APP_SERVICE_SECRET} = process.env;

  try {
    const response = await axios.post('https://p.unity.cn/v1/transactions/search', {
      outTradeNo: req.out_trade_no,
      transactionType: "RealMoneyPurchase"
    }, {
      headers: {
        'Content-Type': 'application/json',
        'Authorization': 'Basic ' + btoa(UOS_APP_ID + ':' + UOS_APP_SERVICE_SECRET)
      }
    });

    return {
      statusCode: 200,
      headers: {"Content-Type":"application/json"},
      body: JSON.stringify(response.data),
    };

  } catch (err) {
    console.error(err);
    return {
      statusCode: 400,
      headers: {"Content-Type":"application/json"},
      body: JSON.stringify(err.response.data),
    };
  }
};